<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'db.php'; // Include your database conn

$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the raw POST data
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (isset($data['add'])) {
        $youtubeLink = $data['youtubeLink'] ?? '';
        
        // Validate and sanitize the input
        $youtubeLink = filter_var($youtubeLink, FILTER_SANITIZE_STRING);
        
        if (empty($youtubeLink)) {
            $response['status'] = 'error';
            $response['message'] = 'YouTube link is required';
        } else {
            // Insert into database
            $sql = "INSERT INTO youtubelink (link) VALUES ('$youtubeLink')";
            
            if (mysqli_query($conn, $sql)) {
                $response['status'] = 'success';
                $response['message'] = 'YouTube link saved successfully';
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Database error: ' . mysqli_error($conn);
            }
        }
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Invalid request';
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method';
}

echo json_encode($response);
?>